<?php
/**
 * @version   $Id: item.php 29284 2015-12-14 19:11:37Z james $
 * @author    RocketTheme http://www.rockettheme.com
 * @copyright Copyright (C) 2007 - 2016 RocketTheme, LLC
 * @license   http://www.gnu.org/licenses/gpl-2.0.html GNU/GPLv2 only
 */

/**
 * @var $item RokSprocket_Item
 */
?>
<li<?php echo strlen($item->custom_tags) ? ' class="'.$item->custom_tags.'"' : ''; ?> data-mosaic-item>
	<div class="sprocket-mosaic-item" data-mosaic-content>
		<?php echo $item->custom_ordering_items; ?>
		<div class="sprocket-padding">
			<?php if ($item->getPrimaryImage()) :?>
			 <too-animate>
				 <a href="<?php echo $item->getPrimaryLink()->getUrl(); ?>">
					<div class="too-animate-overlay ">
						<div class="too-animate-content">	
							<?php if ($item->getTitle()): ?>
								<h4 class="sprocket-mosaic-title">
									<?php if ($item->getPrimaryLink()): ?>
										<?php echo $item->getTitle();?>
									<?php endif; ?>
								</h4>
							<?php endif; ?>
							
							<?php if ($item->getPrimaryLink()) : ?>
								<span>
									<?php rc_e('READ_MORE'); ?>
								</span>
							<?php endif; ?>	
						</div>	
					</div>		
						<img src="<?php echo $item->getPrimaryImage()->getSource(); ?>" alt="<?php echo strip_tags((!$item->getPrimaryImage()->getAlttext()) ? $item->getTitle() : $item->getPrimaryImage()->getAlttext()); ?>" class="sprocket-mosaic-image" />
			      </a>
			 </too-animate >
			<?php endif; ?>

			<?php if (count($item->custom_tags_list)) : ?>
				<ul class="sprocket-mosaic-tags">
				<?php
					foreach($item->custom_tags_list as $key => $name){
				 		echo ' <li class="sprocket-tags-'.$key.'">'.$name.'</li>';
					}
				?>
				</ul>
			<?php endif; ?>
		</div>
	</div>
</li>
